<?php

defined( 'ABSPATH' ) or exit;

if ( ! class_exists( 'PW_Gift_Cards_Shortcodes' ) ) :

final class PW_Gift_Cards_Shortcodes {

    function __construct() {
        add_shortcode( PWGC_BALANCE_SHORTCODE, array( $this, 'check_balance_shortcode' ) );

        add_action( 'wp_ajax_nopriv_pw-gift-cards-balance', array( $this, 'ajax_balance' ) );
        add_action( 'wp_ajax_pw-gift-cards-balance', array( $this, 'ajax_balance' ) );

        add_action( 'wp_ajax_nopriv_pw-gift-cards-debit', array( $this, 'ajax_debit' ) );
        add_action( 'wp_ajax_pw-gift-cards-debit', array( $this, 'ajax_debit' ) );
    }

    function check_balance_shortcode( $shortcode_attributes, $shortcode_content = '' ) {
        return $this->load_shortcode_template( 'balance.php', $shortcode_attributes, $shortcode_content );
    }

    function ajax_balance( ) {
        check_ajax_referer( 'pw-gift-cards-check-balance', 'security' );

        $number = wc_clean( $_REQUEST['card_number'] );

        $gift_card = new PW_Gift_Card( $number );
        if ( $gift_card->get_id() ) {

            if ( $gift_card->get_active() ) {
                $balance = $gift_card->get_balance();
                if ( $balance !== null ) {
                    $balance = apply_filters( 'pwgc_to_current_currency', $balance );
                    $balance = '<span id="pwgc-balance-amount-value">' . wc_price( $balance ) . '</span>';

                    $expiration_date = $gift_card->get_expiration_date();
                    if ( !empty( $expiration_date ) ) {
                        $expiration_date = date_i18n( wc_date_format(), strtotime( $gift_card->get_expiration_date() ) );
                    }

                    wp_send_json_success( array( 'balance' => $balance, 'expiration_date' => $expiration_date, 'card_number' => $gift_card->get_number() ) );
                }
            } else {
                wp_send_json_error( array( 'message' => __( 'Card is inactive.', 'pw-woocommerce-gift-cards' ) ) );
            }
        } else {
            // Tar-pit to make brute-force guessing inefficient.
            sleep(3);
        }

        wp_send_json_error( array( 'message' => $gift_card->get_error_message() ) );
    }

    function load_shortcode_template( $template_file, $shortcode_attributes, $shortcode_content = '' ) {
        ob_start();

        global $pwgc_shortcode_attributes;
        global $pwgc_shortcode_content;

        $pwgc_shortcode_attributes = $shortcode_attributes;
        $pwgc_shortcode_content = $shortcode_content;

        wp_enqueue_script( 'pw-gift-cards' );

        wc_get_template( "pw-gift-cards/$template_file", array(), '', PWGC_PLUGIN_ROOT . 'templates/woocommerce/' );

        return ob_get_clean();
    }

    function ajax_debit() {
        global $pw_gift_cards;

        check_ajax_referer( 'pw-gift-cards-debit-balance', 'security' );

        $number = wc_clean( $_POST['card_number'] );

        $pw_gift_cards->set_current_currency_to_default();

        $balance = 0;

        $gift_card = new PW_Gift_Card( $number );
        if ( $gift_card->get_id() ) {
            $amount = floatval( $_POST['amount'] );
            $amount = abs( $amount ) * -1; // Ensure it's always negative.

            if ( isset( $_POST['note'] ) ) {
                $note = stripslashes( wc_clean( $_POST['note'] ) );
            } else {
                $note = '';
            }

            if ( ( $gift_card->get_balance() + $amount ) < 0 ) {
                $amount = $gift_card->get_balance() * -1;
            }

            $gift_card->adjust_balance( $amount, $note );

            $balance = $gift_card->get_balance();
            if ( $balance !== null ) {
                $balance = apply_filters( 'pwgc_to_current_currency', $balance );
                $balance = '<span id="pwgc-balance-amount-value">' . wc_price( $balance ) . '</span>';
            }

            wp_send_json( array( 'message' => __( 'Balance adjusted.', 'pw-woocommerce-gift-cards' ), 'balance' => $balance ) );
        } else {
            // Tar-pit to make brute-force guessing inefficient.
            sleep(3);
        }

        wp_send_json_error( array( 'message' => $gift_card->get_error_message() ) );
    }
}

global $pw_gift_cards_shortcodes;
$pw_gift_cards_shortcodes = new PW_Gift_Cards_Shortcodes();

endif;
