<?php

defined( 'ABSPATH' ) or exit;

if ( count( $gift_cards ) == 0 ) {
    ?>
    <h1><?php _e( 'No results', 'pw-woocommerce-gift-cards' ); ?></h1>
    <p><?php _e( 'There are no gift cards found matching your search terms.', 'pw-woocommerce-gift-cards' ); ?></p>
    <?php
} else {
    ?>
    <table id="pwgc-search-results-table" class="pwgc-admin-table">
        <tr>
            <th><?php _e( 'Card Number', 'pw-woocommerce-gift-cards' ); ?></th>
            <th><?php _e( 'Balance', 'pw-woocommerce-gift-cards' ); ?></th>
            <th><?php _e( 'Expiration Date', 'pw-woocommerce-gift-cards' ); ?></th>
            <th><?php _e( 'Recipient', 'pw-woocommerce-gift-cards' ); ?></th>
            <th>&nbsp;</th>
        </tr>
        <?php
            require_once( 'search-results-rows.php' );
        ?>
    </table>
    <script>
        jQuery('.pwgc-view-activity').off('click').on('click', function(e) {
            var row = jQuery(this).closest('tr');
            if (row.find('.pwgc-balance-activity-table').length > 0) {
                row.find('.pwgc-balance-activity-container').remove();
            } else {
                pwgcAdminGiftCardActivity(row);
            }

            e.preventDefault();
            return false;
        });

        jQuery('.pwgc-adjust-balance').off('click').on('click', function(e) {
            var row = jQuery(this).closest('tr');
            var amount = prompt( pwgc.i18n.adjustment_amount_prompt );
            if (amount) {
                pwgcAdjustBalance(row, amount);
            }

            e.preventDefault();
            return false;
        });

        jQuery('.pwgc-add-note').off('click').on('click', function(e) {
            var row = jQuery(this).closest('tr');
            pwgcAdjustBalance(row, 0);

            e.preventDefault();
            return false;
        });

        jQuery('.pwgc-expiration-date').off('click').on('click', function(e) {
            var row = jQuery(this).closest('tr');
            pwgcSetExpirationDate(row);

            e.preventDefault();
            return false;
        });

        jQuery('.pwgc-email').off('click').on('click', function(e) {
            var row = jQuery(this).closest('tr');
            pwgcEmailGiftCard(row);

            e.preventDefault();
            return false;
        });

        jQuery('.pwgc-delete').off('click').on('click', function(e) {
            var row = jQuery(this).closest('tr');
            if (confirm('<?php _e( 'Are you sure you want to delete this gift card?', 'pw-woocommerce-gift-cards' ); ?>')) {
                pwgcDelete(row);
            }

            e.preventDefault();
            return false;
        });

        jQuery('.pwgc-restore').off('click').on('click', function(e) {
            var row = jQuery(this).closest('tr');
            pwgcRestore(row);

            e.preventDefault();
            return false;
        });
    </script>
    <?php
}
