<?php

defined( 'ABSPATH' ) or exit;

global $pw_gift_cards;

foreach( $order->get_items( 'pw_gift_card' ) as $line ) {
    $gift_card = new PW_Gift_Card( $line->get_card_number() );
    if ( $gift_card->get_id() ) {
        $check_balance_url = $gift_card->check_balance_url();
    } else {
        $check_balance_url = admin_url();
    }

    ?>
    <tr>
        <td class="label">
            <?php _e( 'PW Gift Card', 'pw-woocommerce-gift-cards' ); ?> <a href="<?php echo $check_balance_url; ?>"><?php echo $line->get_card_number(); ?></a>:
        </td>
        <td width="1%"></td>
        <td class="total">
            <?php
                $amount = apply_filters( 'pwgc_to_order_currency', $line->get_amount() * -1, $order );
                if ( class_exists( 'WC_Aelia_CurrencySwitcher' ) && isset( $GLOBALS['woocommerce-aelia-currencyswitcher'] ) ) {
                    ?>
                    <span class="woocommerce-Price-amount amount"><?php echo $amount; ?></span>
                    <?php
                } else {
                    echo wc_price( $amount );
                }
            ?>
        </td>
    </tr>
    <?php
}
